--REBUILD INDEX
DECLARE @DatabaseName SYSNAME   = DB_NAME(),  @TableName VARCHAR(256) 

DECLARE @FILLFACTOR INT = 85

DECLARE @DynamicSQL NVARCHAR(max) =

 'DECLARE curAllTablesInDB CURSOR FOR SELECT TABLE_SCHEMA +

 ''.'' + TABLE_NAME AS TABLENAME  

 FROM [' + @DatabaseName + '].INFORMATION_SCHEMA.TABLES WHERE

 TABLE_TYPE = ''BASE TABLE'''  

 

BEGIN 

  EXEC sp_executeSQL @DynamicSQL  -- create tables cursor

  OPEN curAllTablesInDB  

  FETCH NEXT FROM curAllTablesInDB INTO @TableName  

  WHILE (@@FETCH_STATUS = 0) 

  BEGIN  

       SET @DynamicSQL = 'ALTER INDEX ALL ON ' + @TableName +

         ' REBUILD WITH (FILLFACTOR = ' + CONVERT(VARCHAR,@FILLFACTOR) + ')' 

       PRINT @DynamicSQL

       -- ALTER INDEX ALL ON Purchasing.ShipMethod REBUILD WITH (FILLFACTOR = 85)

       EXEC sp_executeSQL @DynamicSQL 

       FETCH NEXT FROM curAllTablesInDB INTO @TableName  

   END   -- cursor WHILE

   CLOSE curAllTablesInDB  

   DEALLOCATE curAllTablesInDB
   end

   TRUNCATE TABLE sSystem.tExceptionLog

   Delete from sstudent.tstudentmaster Where id not in (select StudentId from sstudent.tAcademic)